data{
    int n;
    array[n] int<lower=0> P;
    array[n] int<lower=0> N;
    vector[n] age_g2;
    vector[n] age_g3;
    vector[n] sex_g;
}
parameters{
    vector[4] gamma;
}
transformed parameters{
    vector[n] prev;
    {
        for(i in 1:n){
            prev[i] = inv_logit(gamma[1] + 
                                gamma[2]*age_g2[i] +         
                                gamma[3]*age_g3[i] +
                                gamma[4]*sex_g[i]);
        }
    }
}
model{
    // Likelihood
    for(i in 1:n){
        N[i] ~ binomial(P[i],prev[i]);
    }
    // Priors
    for(j in 1:4){
        gamma[j] ~ normal(0, 100);
    }
}
generated quantities{
    //  log-likelihood
    vector[n] log_likelihood;
  {
    for(i in 1:n){
      log_likelihood[i] = binomial_lpmf(N[i] | P[i],prev[i]);
    }
  }
  real log_lik;
  {
    log_lik = sum(log_likelihood);
  }
}